<?php
use common\models\BotCommands;
use frontend\models\BotCommandsSearch;
use yii\helpers\Html;
use kartik\grid\GridView;
use yii\helpers\Url;
use johnitvn\ajaxcrud\CrudAsset;
use yii\bootstrap\Modal;
use common\models\Bots;
use common\models\Commands;

$sModel = new BotCommandsSearch();
$dProvider = $sModel->search(Yii::$app->request->queryParams);


CrudAsset::register($this);

?>
<?= GridView::widget([
    'dataProvider' => $dProvider,
    'filterModel' => $sModel,
    'pjax' => 'true',
    'tableOptions' => ['class' => 'special_table table-striped table-bordered table-sm'],
    'columns' => [
	    [
	        'class' => 'kartik\grid\ExpandRowColumn',
	        'value' => function ($model,$key,$index,$column) {
	            return GridView::ROW_COLLAPSED;
	        },
	        'detail' => function ($model, $key, $index, $column) {
	            return Yii::$app->controller->renderPartial('_expand-bots-commands', ['model' => $model]);
	        },
	        'expandOneOnly' => true,
	        'expandIcon' => '<span>+</span>',
	        'collapseIcon' => '<span>-</span>',
	    ],
	    /*[
	    	'attribute'=>'bot_id',
	    ],*/
        [
	    	'class'=>'\kartik\grid\DataColumn',
	        'attribute'=>'commandtype',
	        'contentOptions' => ['class' => 'text-left', 'style' => 'width:120px;'],
	        'value' => function ($model) {
	            if($model->commandtype == 0){
	                return 'no_operation';
	            } elseif($model->commandtype == 1){
	                return 'Get_SystemInfo';
	            } elseif($model->commandtype == 10){
	                return 'Run_EXE';
	            } elseif($model->commandtype == 11){
	                return 'Run_DLL';
	            } elseif($model->commandtype == 12){
	                return 'Run_BAT';
	            } elseif($model->commandtype == 13){
	                return 'Run_PWS';
	            } elseif($model->commandtype == 14){
	                return 'Reset';
	            } elseif($model->commandtype == 15){
	                return 'Terminate_Process';
	            } elseif($model->commandtype == 16){
	                return 'Download_file';
	            } elseif($model->commandtype == 100){
	                return 'Suicide';
	            }
	        },
	        'filterType' => \kartik\grid\GridView::FILTER_SELECT2,
	        'filter' => [ 
	            null => 'All',
	            0 => 'no_operation',
	            1 => 'Get_SystemInfo',
	            10 => 'Run_EXE',
	            11 => 'Run_DLL',
	            12 => 'Run_BAT',
	            13 => 'Run_PWS',
	            14 => 'Reset',
	            15 => 'Terminate_Process',
	            16 => 'Download_file',
	            100 => 'Suicide',
	        ],
	    ],
        [
	        'attribute'=>'created_at',
	        'contentOptions' => ['class' => 'text-left', 'style' => 'width:120px;'],
	        'format'=>['date', 'dd.MM.Y HH:mm'],
	    ],
	    [
	    	'class'=>'\kartik\grid\DataColumn',
	        'attribute'=>'status',
	        'contentOptions' => ['class' => 'text-left', 'style' => 'width:30px;'],
	        'value' => function ($model) {
	            if($model->status == 0){
	                return 'waiting';
	            } elseif($model->status == 1){
	                return 'pending';
	            } elseif($model->status == 2){
	                return 'done';
	            } elseif($model->status == 3){
	                return 'fail';
	            }
	        },
	        'filterType' => \kartik\grid\GridView::FILTER_SELECT2,
	        'filter' => [ // offline, not_valid, key_lock, ad_no, ad_yes
	            null => 'All',
	            0 => 'waiting',
	            1 => 'pending',
	            2 => 'done',
	            3 => 'fail',
	        ],
	    ],
        [
	        'attribute'=>'usercommand',
	        'contentOptions' => ['class' => 'usercommand text-left'],
	    ],
	    [
	        'class' => 'kartik\grid\ActionColumn',
	        'dropdown' => false,
	        'vAlign'=>'middle',
	        'template' => '{downloadresult} {repeat}',
	        'urlCreator' => function($action, $model, $key, $index) { 
	                return Url::to([$action,'id'=>$key]);
	        },
	        'buttons' => [
	            'repeat' => function ($url) {
	            	
                    return Html::a(
	                    '<span class="glyphicon glyphicon-repeat repeatCommand" aria-hidden="true"></span>',
	                    'javascript:void(0)', 
	                    [
	                        'title' => 'Repeat command',
	                        'data-pjax' => '0',
	                        'aria-label' => 'Repeat',
	                        'class' => 'repeatCommand',
	                    ]);
	                
            	},

	            'downloadresult' => function ($url) {
	                return Html::a(
	                    '<span class="glyphicon glyphicon-download" aria-hidden="true"></span>',
	                    $url, 
	                    [
	                        'title' => 'Download result',
	                        'data-pjax' => '0',
	                        'aria-label' => 'Download',
	                        //'role'=>'modal-remote',
	                        
	                    ]
	                );
	            },
	            
	        ],
	        
	    ],

    ],
]); 
?>

<?php Modal::begin([
    "id"=>"ajaxCrudModal",
    "footer"=>"",// always need it for jquery plugin
])?>
<?php Modal::end(); ?>
